# UptimeWatcher

UptimeWatcher is designed to monitor the availability and performance of websites and services. It provides real-time monitoring, visual logging, and automated email notifications for downtime or performance degradation.

## Features

- **Real-time Monitoring**: Periodically checks multiple targets (URLs) at a configurable interval.
- **Status Tracking**: Tracks three primary states:
    - `UP`: The service is running and returned the expected content.
    - `SLOW`: The service is responsive but exceeds the defined response time threshold.
    - `DOWN`: The service is unreachable or returned incorrect content.
- **Smart Alerts**:
    - Immediate email notifications when a service goes `DOWN`.
    - Recovery notifications when a service returns `UP`.
    - Hysteresis-based `SLOW` alerts (triggered after 3 consecutive slow responses) to avoid noise.
- **Automated Logging**: Daily rotating activity logs stored in the system's standard log directory.
- **Configurable Thresholds**: Define custom "Slow" timing thresholds and response time offsets per target.

## Usage

### Configuration

The application is primarily configured via the **Config** button in the app's header. This opens a modal where you can manage targets and general settings. All settings are persisted in a `config.json` file.

#### File Locations

- **macOS**: `~/Library/Application Support/UptimeWatcher/config.json`
- **Windows**: `%APPDATA%\UptimeWatcher\config.json`
- **Linux**: `~/.config/UptimeWatcher/config.json`

#### Key Settings

- **Targets**: A list of services to monitor. Each target requires:
    - `Server / Name`: Identifying labels for the service.
    - `URL`: The full endpoint to monitor.
    - `Expected Text`: A string that must exist in the response for a successful `UP` status.
- **Interval**: Frequency of checks in seconds.
- **Logs**: Number of days to retain rotating log files and the maximum number of check batches to display in the UI.
- **SMTP**: Mail server credentials for sending downtime alerts.

#### Timing & Status Thresholds

The `timing` array defines how the app categorizes response times and applies visual styles. While targets are managed via the UI, the specific timing thresholds are currently defined in the `config.json` under `settings.timing`:

- **Status Calculation**: The app compares the adjusted response time (actual time minus a target's `slowOffset`) against these thresholds.
- **Slow Alerting**: The system specifically monitors for a timing entry with the label `"Slow"`. If a service exceeds this duration for 3 consecutive checks, a `SLOW` alert is triggered.
- **Data Structure**:
    - `label`: Name of the threshold (e.g., "Slow", "Caution", "Fast").
    - `seconds`: The time threshold in seconds.
    - `color`: The hex color code used for log entries meeting this threshold.

#### Example config.json
Below is the default configuration structure generated by the application on first launch:

```json
{
  "settings": {
    "intervalSeconds": 60,
    "logFileKeepDays": 10,
    "logViewerChecksMax": 10,
    "emailSendTo": [],
    "emailSMTP_Host": "",
    "emailSMTP_Port": "",
    "emailSMTP_UseSSL": false,
    "emailSMTP_UseTLS": true,
    "emailSMTP_Username": "",
    "emailSMTP_Password": "",
    "timing": [
      { "label": "Slow", "seconds": 2.0, "color": "#701a75" },
      { "label": "Late", "seconds": 1.0, "color": "#b91c1c" },
      { "label": "Caution", "seconds": 0.8, "color": "#d97706" },
      { "label": "OK", "seconds": 0.3, "color": "#2563eb" },
      { "label": "Fast", "seconds": 0, "color": "#16a34a" }
    ]
  },
  "targets": [
    {
      "labelServer": "Srv001",
      "labelName": "google.com",
      "url": "https://google.com",
      "expectedText": "Search"
    },
    {
      "labelServer": "Srv002",
      "labelName": "github.com",
      "url": "https://github.com",
      "expectedText": "GitHub"
    }
  ]
}
```

### Logging Locations

Activity logs are automatically rotated daily and stored in:

- **macOS**: `~/Library/Logs/UptimeWatcher/`
- **Windows**: `%APPDATA%\UptimeWatcher\Logs\`
- **Linux**: `~/.local/state/UptimeWatcher/logs/` (or `$XDG_STATE_HOME/UptimeWatcher/logs/`)
